//=============================================================================
// WeponTypeAddTag.js
// ----------------------------------------------------------------------------
// (C)2024 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2024/05/19 初版
// ----------------------------------------------------------------------------
// [Site]   : https://ci-en.net/creator/14684
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 武器装備判定追加タグ
 * @target MZ
 * @author くろあめ
 * 
 * @help
 * 武器や防具、ステートのメモに
 * <WTypeAdd:n> と記述すると
 * それらの武器防具装備時、およびステートの付与時に
 * 武器タイプID:nの武器を装備している扱いにすることができます。
 * 複数のIDを指定したい場合は、カンマ区切りで記載してください
 *
 * 例１（武器タイプIDの名称はデフォルト基準）
 * 防具に <WTypeAdd:1> と記述すると
 * その防具の装備中は、装備武器に関わらず、短剣を装備している判定となり
 * 短剣を装備している必要のあるスキルが使用できます。
 * ⇒隠し刃付きの篭手、などを表現できます
 *
 * 例２（武器タイプIDの名称はデフォルト基準）
 * ステートに <WTypeAdd:7,8,9> と記述すると
 * そのステートが付与されている間は、装備武器に関わらず、弓・クロスボウ・銃を装備している判定となり
 * 弓・クロスボウ・銃を装備している必要のあるスキルが使用できます。
 * ⇒一定時間呼び出せる魔法の砲台、などを表現できます
 *
 * このプラグインは、コアスクリプトの Game_Actor.prototype.isWtypeEquipped 関数を再定義します
 * できるだけ上の方に配置することを推奨します
 * また、やや競合性が高いという事に留意してください。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 *
 */

(function() {

'use strict';
const script = document.currentScript;
const pluginParams = PluginManagerEx.createParameter(script);

// 再定義 特定の武器タイプを装備しているかどうかの判定
Game_Actor.prototype.isWtypeEquipped = function(wtypeId) {
    var typeHit = this.weapons().some(weapon => weapon.wtypeId === wtypeId);
    
    if (typeHit){
        return typeHit;
    }
    var states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.WTypeAdd){
            var getMeta = states[i].meta.WTypeAdd.split(',').map(Number);
            typeHit = getMeta.some(getMeta => getMeta === wtypeId);
            if (typeHit){
                return typeHit;
            }
        }
    }
    var equips = this.equips();
    for (let i = 0; i < equips.length; i++) {      
        if (equips[i] && equips[i].meta && equips[i].meta.WTypeAdd){
            var getMeta = equips[i].meta.WTypeAdd.split(',').map(Number);
            typeHit = getMeta.some(getMeta => getMeta === wtypeId);
            if (typeHit){
                return typeHit;
            }
        }
    }
    
};

})();